/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.items.modifiers.tool;

import java.util.List;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BreakSpeedModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import tcintegrations.util.ResourceLocationHelper;

public class ForgottenModifier
extends NoLevelsModifier
implements MeleeDamageModifierHook,
BreakSpeedModifierHook,
TooltipModifierHook {
    private static final Component MINING_SPEED = Component.m_237115_((String)Util.m_137492_((String)"modifier", (ResourceLocation)ResourceLocationHelper.resource("forgotten.mining_speed")));
    private static final Component ATTACK_INCREASE = Component.m_237115_((String)Util.m_137492_((String)"modifier", (ResourceLocation)ResourceLocationHelper.resource("forgotten.attack_increase")));

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, ModifierHooks.MELEE_DAMAGE, ModifierHooks.BREAK_SPEED, ModifierHooks.TOOLTIP);
    }

    public float getMeleeDamage(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float baseDamage, float damage) {
        LivingEntity target = context.getLivingTarget();
        if (target != null) {
            LivingEntity attacker = context.getAttacker();
            BlockState state = attacker.f_19853_.m_8055_(attacker.m_20097_());
            if (tool.hasTag(TinkerTags.Items.MELEE) && this.isUndergarden(state, attacker)) {
                return damage * 1.5f;
            }
        }
        return damage;
    }

    public void onBreakSpeed(IToolStackView tool, ModifierEntry modifier, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        BlockState state = event.getState();
        if (tool.hasTag(TinkerTags.Items.HARVEST) && isEffective && state != null && this.isUndergarden(state, (LivingEntity)event.getEntity())) {
            event.setNewSpeed(event.getOriginalSpeed() * 1.5f);
        }
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        BlockState state;
        BlockState blockState = state = player != null ? player.f_19853_.m_8055_(player.m_20097_()) : null;
        if (state != null && this.isUndergarden(state, (LivingEntity)player)) {
            if (tool.hasTag(TinkerTags.Items.HARVEST)) {
                TooltipModifierHook.addPercentBoost((Modifier)modifier.getModifier(), (Component)MINING_SPEED, (double)0.5, tooltip);
            }
            if (tool.hasTag(TinkerTags.Items.MELEE)) {
                TooltipModifierHook.addPercentBoost((Modifier)modifier.getModifier(), (Component)ATTACK_INCREASE, (double)0.5, tooltip);
            }
        }
    }

    private boolean isUndergarden(BlockState state, LivingEntity livingEntity) {
        return Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_())).m_135827_().equals("undergarden") && livingEntity.m_6072_();
    }
}

